﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VIMT.VideoVisit.Messages
{
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VIMTTmpUpdateAppointmentRequest)]
    [DataContract]
    public class VIMTTmpUpdateAppointmentRequest : MessageBase
    {
        [DataMember]
        public string OrganizationName { get; set; }

        [DataMember]
        public Guid UserId { get; set; }

        [DataMember]
        public Guid RelatedParentId { get; set; }

        [DataMember]
        public string RelatedParentEntityName { get; set; }

        [DataMember]
        public string RelatedParentFieldName { get; set; }

        [DataMember]
        public bool LogTiming { get; set; }

        [DataMember]
        public bool LogSoap { get; set; }

        [DataMember]
        public bool Debug { get; set; }

        [DataMember]
        public VIMTTmpUpdateAppointmentRequestData VIMTTmpUpdateAppointmentRequestDataInfo { get; set; }
    }

    [DataContract]
    public class VIMTTmpUpdateAppointmentRequestData
    {
        [DataMember]
        public string Id { get; set; }

        [DataMember]
        public string SourceSystem { get; set; }

        [DataMember]
        public VIMTTmpPatients[] Patients { get; set; }

        [DataMember]
        public int Duration { get; set; }

        [DataMember]
        public string DateTime { get; set; }

        [DataMember]
        public VIMTTmpStatus Status { get; set; }

        [DataMember]
        public VIMTTmpSchedulingRequestType SchedulingRequestType { get; set; }

        [DataMember]
        public bool SchedulingRequestTypeSpecified { get; set; }

        [DataMember]
        public VIMTTmpAppointmentKind AppointmentKind { get; set; }

        [DataMember]
        public VIMTTmpAppointmentType Type { get; set; }

        [DataMember]
        public bool TypeSpecified { get; set; }

        [DataMember]
        public string BookingNotes { get; set; }

        [DataMember]
        public string DesiredDate { get; set; }

        [DataMember]
        public bool DesiredDateSpecified { get; set; }

        [DataMember]
        public VIMTTmpProviders[] Providers { get; set; }

        [DataMember]
        public string Version { get; set; }

        [DataMember]
        public string SamlToken { get; set; }
    }
}